% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgen.R
\name{rBetaBin}
\alias{rBetaBin}
\title{Random generator from the beta-binomial distribution}
\usage{
rBetaBin(n, size = NULL, mu = NULL, theta = NULL, phi = NULL)
}
\arguments{
\item{n}{the number of observations. If \code{length(n)} > 1, the length is taken to be the number required.}

\item{size}{the total number of trials.}

\item{mu}{the mean parameter. It must lie in (0, 1).}

\item{theta}{the overdispersion parameter. It must  lie in (0, 1).}

\item{phi}{the precision parameter. It is an alternative way to specify the \code{theta} parameter. It must be a positive real value.}
}
\value{
A vector of length \code{n}.
}
\description{
The function randomly generates values from the beta-binomial distribution.
}
\examples{
rBetaBin(n=100, size=40, mu = 0.5, theta = 0.4)
rBetaBin(n=100, size=40, mu = 0.5, phi = 1.5)

}
\references{
{
Ascari, R., Migliorati, S. (2021). A new regression model for overdispersed binomial data accounting for outliers and an excess of zeros. Statistics in Medicine, \bold{40}(17), 3895--3914. doi:10.1002/sim.9005
}
}
