% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04.FF_either.R
\name{get.matrix.adjacency}
\alias{get.matrix.adjacency}
\title{Create any firm-firm (FF) matrix for common ownership or board interlocks}
\usage{
get.matrix.adjacency(
  ...,
  who = c("managers", "owners"),
  ties = 3,
  id_as_firm_name = NULL,
  Matrix = NULL,
  self_ties = FALSE
)
}
\arguments{
\item{...}{Either multiple objects of class \code{firm} or a list of such objects}

\item{who}{Whether to extract the 'managers' or the 'owners' (minimum unambiguous string)}

\item{ties}{Type of ties to create. Defaults to \code{2}; for other possible values, see details.}

\item{id_as_firm_name}{Whether to use the ticker as the firm's name. Defaults to \code{TRUE} if all firms' id is neither \code{NULL} nor \code{NA}.}

\item{Matrix}{Whether to use the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package}. Defaults to \code{TRUE} when any matrix in the pipeline contains more than 10,000 cells and the package is installed.}

\item{self_ties}{Whether to allow self-ties (a 'loop' in graph theory). Defaults to \code{FALSE}.}
}
\value{
A matrix object of class \code{financial_matrix}(possibly using the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package})
}
\description{
Function to create a firm-firm (FF) matrix based on ownership or board interlocks:
}
\details{
The possible values of \code{ties} and their effect relative to the value of \code{who} are:

\code{binary} or \code{0} for binary ties. Namely:
 \itemize{
  \item for \code{owners}: \eqn{1} if there is at least one common owner, \eqn{0} otherwise;
  \item for \code{managers}: \eqn{1} if there is at least one common manager, \eqn{0} otherwise.
 }

 \code{naive}, or \code{1} for 'naively' valued ties. Namely:
 \itemize{
   \item  for \code{owners}, the number of common owners;
   \item  for \code{managers}, the number of common managers.
  }

\code{share} or \code{2} (the default) for 'normalised' tie values. Namely:
\itemize{
 \item for \code{owners}, the share of \eqn{i}'s owners who are also amongst \eqn{j}'s owners;
 \item for \code{managers}, the share of \eqn{i}'s managers who are also amongst \eqn{j}'s managers.
}
}
\seealso{
\link{FF} \link{FF.binary.ownership} \link{FF.binary.management} \link{FF.naive.ownership} \link{FF.naive.management} \link{FF.norm.ownership} \link{FF.norm.management}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
\keyword{internal}
