% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_swap_functions.R
\name{swap_pairs}
\alias{swap_pairs}
\title{Swap pairs in a matrix of integers}
\usage{
swap_pairs(X, starting_dist = 3, stop_iter = 100)
}
\arguments{
\item{X}{A matrix of integers.}

\item{starting_dist}{The minimum starting distance to enforce between pairs of occurrences
of the same integer. Default is 3.}

\item{stop_iter}{The maximum number of iterations to perform. Default is 100.}
}
\value{
A list containing the following elements:
\item{optim_design}{The modified matrix.}
\item{designs}{A list of all intermediate designs, starting from the input matrix.}
\item{distances}{A list of all pair distances for each intermediate design.}
\item{min_distance}{An integer indicating the minimum distance between pairs of occurrences of the same integer.}
\item{pairswise_distance}{A data frame with the pairwise distances for the final design.}
}
\description{
Modifies the input matrix \code{X} to ensure that the distance between any two occurrences
of the same integer is at least a dist \code{d}, by swapping one of the occurrences with a
random occurrence of a different integer that is at least \code{d} away. The function
starts with \code{starting_dist = 3} and increases it by \code{1} until the algorithm no longer 
converges or \code{stop_iter} iterations have been performed.
}
\examples{
# Create a matrix X with the numbers 1 to 10 are twice and 11 to 50 are once.
# The matrix has 6 rows and 10 columns
set.seed(123)
X <- matrix(sample(c(rep(1:10, 2), 11:50), replace = FALSE), ncol = 10)
X
# Swap pairs
B <- swap_pairs(X, starting_dist = 3)
B$optim_design
B$designs
B$distances


}
\author{
Jean-Marc Montpetit [aut], Didier Murillo [aut]
}
