% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedirt_gpcm.R
\name{g_logL_gpcm}
\alias{g_logL_gpcm}
\title{Gradient of Log-Likelihood for the federated graded Model}
\usage{
g_logL_gpcm(a, b, data, q = 21, lower_bound = -3, upper_bound = 3)
}
\arguments{
\item{a}{Numeric vector of item discrimination parameters in the graded model.}

\item{b}{Numeric vector of item difficulty parameters in the graded model.}

\item{data}{The matrix of observed item responses, with individuals in rows and items in columns.}

\item{q}{The number of Gaussian quadrature points for numerical integration (default is 21).}

\item{lower_bound}{The lower bound for Gaussian quadrature integration (default is -3).}

\item{upper_bound}{The upper bound for Gaussian quadrature integration (default is 3).}
}
\value{
A list containing two elements: the gradient vector with respect to item discrimination parameters ('a') and the gradient vector with respect to item difficulty parameters ('b').
}
\description{
Calculates the gradients of the log-likelihood function with respect to the item discrimination (a) and difficulty (b) parameters for the graded IRT model. This computation is vital for optimizing the item parameters via gradient-based optimization algorithms.
}
\details{
The function approximates the partial derivatives by utilizing Gaussian quadrature for numerical integration. Memoization techniques are used to cache intermediate results, which is crucial for efficient computation because it avoids redundant calculations. This can significantly speed up iterative algorithms, particularly in the context of large datasets.
}
