% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NHD_FUNCTIONS.R
\name{get_nhd}
\alias{get_nhd}
\title{Download and crop the National Hydrography Dataset.}
\usage{
get_nhd(template, label, raw.dir = "./RAW/NHD/",
  extraction.dir = "./EXTRACTIONS/NHD/", force.redo = FALSE)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve 
as a template for cropping.}

\item{label}{A character string naming the study area.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to "./RAW/NHD/".}

\item{extraction.dir}{A character string indicating where the extracted and cropped NHD shapefiles should be put.
The directory will be created if missing. Defaults to "./EXTRACTIONS/NHD/".}

\item{force.redo}{If an extraction for this template and label already exists, should a new one be created?}
}
\value{
A list of Spatial* objects extracted from the National Hydrography Dataset.
}
\description{
\code{get_nhd} returns a list of Spatial* objects extracted 
from the National Hydrography Dataset.
}
\examples{
\dontrun{
# Extract data for the Village Ecodynamics Project "VEPIIN" study area:
# http://village.anth.wsu.edu
vepPolygon <- polygon_from_extent(raster::extent(672800,740000,4102000,4170000), 
     proj4string="+proj=utm +datum=NAD83 +zone=12")

# Get the NHD (USA ONLY)
NHD <- get_nhd(template=vepPolygon, label="VEPIIN")

# Plot the VEP polygon
plot(vepPolygon)

# Plot the NHD data
plot(NHD$NHDFlowline, add=T)
plot(NHD$NHDLine, add=T)
plot(NHD$NHDArea, col='black', add=T)
plot(NHD$NHDWaterbody, col='black', add=T)
}
}

