% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.mapping.R
\name{hash.mapping}
\alias{hash.mapping}
\title{Extract mapping between hash and original values}
\usage{
hash.mapping(matrix)
}
\arguments{
\item{matrix}{Matrix returned by \code{hashed.model.matrix} function}
}
\value{
a named \code{numeric} vector
}
\description{
Extract mapping between hash and original values
}
\details{
Generate a mapping between original values and hashes. 

Option \code{create.mapping = T} needs to be used in function \code{hashed.model.matrix}.

Original values are stores in the names of the vector.
}
\examples{
data(ipinyou)

m <- hashed.model.matrix(~., ipinyou.train, 2^10, create.mapping = TRUE)
mapping <- hash.mapping(m)

}
\author{
Michael Benesty
}
