% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/j_kiener7.R
\name{kiener7}
\alias{kiener7}
\alias{dkiener7}
\alias{pkiener7}
\alias{qkiener7}
\alias{rkiener7}
\alias{dpkiener7}
\alias{dqkiener7}
\alias{lkiener7}
\alias{dlkiener7}
\alias{qlkiener7}
\alias{varkiener7}
\alias{ltmkiener7}
\alias{rtmkiener7}
\alias{dtmqkiener7}
\alias{eskiener7}
\title{Asymmetric Kiener Distribution K7 (K2)}
\usage{
dkiener7(x, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), log = FALSE)

pkiener7(q, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), lower.tail = TRUE,
  log.p = FALSE)

qkiener7(p, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), lower.tail = TRUE,
  log.p = FALSE)

rkiener7(n, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), same_p = FALSE)

dpkiener7(p, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), log = FALSE)

dqkiener7(p, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), log = FALSE)

lkiener7(x, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0))

dlkiener7(lp, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), log = FALSE)

qlkiener7(lp, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), lower.tail = TRUE)

varkiener7(p, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), lower.tail = TRUE,
  log.p = FALSE)

ltmkiener7(p, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), lower.tail = TRUE,
  log.p = FALSE)

rtmkiener7(p, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), lower.tail = TRUE,
  log.p = FALSE)

dtmqkiener7(p, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), lower.tail = TRUE,
  log.p = FALSE)

eskiener7(p, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), lower.tail = TRUE,
  log.p = FALSE, signedES = FALSE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{coefk}{vector of 7 parameters \code{c(m,g,a,k,w,d,e)} 
or matrix with 7 columns.}

\item{log}{logical. If TRUE, densities are given in log scale.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical. If TRUE, use p. If FALSE, use 1-p.}

\item{log.p}{logical. If TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{n}{integer. Number of observations. If length(n) > 1, the length is
taken to be the number required.}

\item{same_p}{logical. If FALSE (default), random probabilies are generated 
on the fly. If TRUE, the same set of random probabilities is 
used for each line of coefk (if coefk is a matrix).}

\item{lp}{vector of logit of probabilities.}

\item{signedES}{logical. FALSE (default) returns positive numbers for 
left and right tails. TRUE returns negative number 
(= \code{ltmkiener7}) for left tail and positive number 
(= \code{rtmkiener7}) for right tail.}
}
\description{
Density, distribution function, quantile function, random generation,
value-at-risk, expected shortfall (+ signed left/right tail mean) 
and additional formulae for asymmetric Kiener distribution K7 = K2.
With K7, the vector of parameters is provided as \code{coefk}, usually estimated 
with \code{\link{paramkienerX}} (and ~X5,~X7) or \code{\link{regkienerLX}$coefk}. 
Main inputs can be supplied as vector (\code{x,q,p}) and matrix (\code{coefk})  
and the resulting output is a matrix (useful for simulation).
}
\details{
Kiener distributions use the following parameters, some of them being redundant. 
See \code{\link{aw2k}} and \code{\link{pk2pk}} for the formulas and 
the conversion between parameters:
\itemize{
  \item{ \code{m} (mu) is the median of the distribution. }
  \item{ \code{g} (gamma) is the scale parameter. }
  \item{ \code{a} (alpha) is the left tail parameter. } 
  \item{ \code{k} (kappa) is the harmonic mean of \code{a} and \code{w} 
         and describes a global tail parameter. }
  \item{ \code{w} (omega) is the right tail parameter. } 
  \item{ \code{d} (delta) is the distortion parameter. }
  \item{ \code{e} (epsilon) is the eccentricity parameter. }
}

Kiener distribution \code{K7} is designed after \code{\link{kiener2}} 
but uses as input \code{coefk} rather than \code{m}, \code{g}, \code{a} 
and \code{w}. 

The d, p functions have no explicit forms. They are provided here for 
convenience. They are estimated from a reverse optimization on the quantile 
function and can be (very) slow, depending the number of points to estimate. 
We recommand to use the quantile function as much as possible. 
WARNING: Results may become inconsistent when \code{a} or \code{w} are
smaller than 1. 

\code{qkiener7} function is defined for p in (0, 1) by: 
  \deqn{ qkiener7(p, coefk) = 
                  m + g * k * (- exp(-logit(p)/a) + exp(logit(p)/w) ) }
where k is the harmonic mean of the tail parameters \code{a} and \code{w} 
calculated by \eqn{k = aw2k(a, w)}.

\code{rkiener7} generates \code{n} random quantiles.

In addition to the classical d, p, q, r functions, the prefixes 
dp, dq, l, dl, ql are also provided.

\code{dpkiener7} is the density function calculated from the probability p. 
It is defined for p in (0, 1) by: 
  \deqn{ dpkiener7(p, coefk) = 
         p * (1 - p) / k / g / ( exp(-logit(p)/a)/a + exp(logit(p)/w)/w }

\code{dqkiener7} is the derivate of the quantile function calculated from 
the probability p. It is defined for p in (0, 1) by: 
  \deqn{ dqkiener7(p, coefk) = 
         k * g / p / (1 - p) * ( exp(-logit(p)/a)/a + exp(logit(p)/w)/w ) }

\code{lkiener7} function is estimated from a reverse optimization and can 
be (very) slow depending the number of points to estimate. Initialization 
is done by assuming a symmetric distribution \code{\link{lkiener1}} 
around the harmonic mean \code{k}, then optimization is performed to 
take into account the true values \code{a} and \code{w}. 
The result can be then compared to the empirical probability logit(p). 
WARNING: Results may become inconsistent when \code{a} or \code{w} are
smaller than 1. 

\code{dlkiener7} is the density function calculated from the logit of the 
probability lp = logit(p).  
it is defined for lp in (-Inf, +Inf) by: 
   \deqn{ dlkiener7(lp, coefk) = 
          p * (1 - p) / k / g / ( exp(-lp/a)/a + exp(lp/w)/w ) }

\code{qlkiener7} is the quantile function calculated from the logit of the 
probability. It is defined for lp in (-Inf, +Inf) by: 
   \deqn{ qlkiener7(lp, coefk) = 
          m + g * k * ( - exp(-lp/a) + exp(lp/w) ) }

\code{varkiener7} designates the Value a-risk and turns negative numbers 
into positive numbers with the following rule:
   \deqn{ varkiener7 <- if(p <= 0.5) { - qkiener7 } else { qkiener7 } }
Usual values in finance are \code{p = 0.01}, \code{p = 0.05}, \code{p = 0.95} and 
\code{p = 0.99}. \code{lower.tail = FALSE} uses \code{1-p} rather than {p}.

\code{ltmkiener7}, \code{rtmkiener7} and \code{eskiener7} are respectively the 
left tail mean, the right tail mean and the expected shortfall of the distribution 
(sometimes called average VaR, conditional VaR or tail VaR). 
Left tail mean is the integrale from \code{-Inf} to \code{p} of the quantile function 
\code{qkiener7} divided by \code{p}.
Right tail mean is the integrale from \code{p} to \code{+Inf} of the quantile function 
\code{qkiener7} divided by 1-p.
Expected shortfall turns negative numbers into positive numbers with the following rule:
   \deqn{ eskiener7 <- if(p <= 0.5) { - ltmkiener7 } else { rtmkiener7 } }
Usual values in finance are \code{p = 0.01}, \code{p = 0.025}, \code{p = 0.975} and 
\code{p = 0.99}. \code{lower.tail = FALSE} uses \code{1-p} rather than {p}.

\code{dtmqkiener7} is the difference between the left tail mean and the quantile 
when (p <= 0.5) and the difference between the right tail mean and the quantile 
when (p > 0.5). It is in quantile unit and is an indirect measure of the tail curvature.
}
\examples{

head(ED <- fatreturns(extractData())) 
(coefk  <- paramkienerX(ED, dgts = 3))  
x  <- -4
xx <- -4:4
p  <- 0.1
pp <- pprobs2

dkiener7(x)
dkiener7(x,  coefk) 
dkiener7(xx)
dkiener7(xx, coefk)

pkiener7(x)
pkiener7(x,  coefk) 
pkiener7(xx)
pkiener7(xx, coefk)

qkiener7(p)
qkiener7(p,  coefk) 
qkiener7(pp)
qkiener7(pp, coefk)

rkiener7(10)
rkiener7(10, coefk)

varkiener7(p)
varkiener7(p, coefk)
varkiener7(pp)
varkiener7(pp, coefk) 

ltmkiener7(p)
ltmkiener7(p, coefk)
ltmkiener7(pp)
ltmkiener7(pp, coefk)

eskiener7(p)
eskiener7(p, coefk)
eskiener7(pp)
eskiener7(pp, coefk) 


}
\references{
P. Kiener, Explicit models for bilateral fat-tailed distributions and 
applications in finance with the package FatTailsR, 8th R/Rmetrics Workshop 
and Summer School, Paris, 27 June 2014.  Download it from:  
\url{http://www.inmodelia.com/exemples/2014-0627-Rmetrics-Kiener-en.pdf}

P. Kiener, Fat tail analysis and package FatTailsR, 
9th R/Rmetrics Workshop and Summer School, Zurich, 27 June 2015. 
Download it from: 
\url{http://www.inmodelia.com/exemples/2015-0627-Rmetrics-Kiener-en.pdf}

C. Acerbi, D. Tasche, Expected shortfall: a natural coherent alternative to 
Value at Risk, 9 May 2001. Download it from: 
\url{http://www.bis.org/bcbs/ca/acertasc.pdf}
}
\seealso{
Symmetric Kiener distribution K1 \code{\link{kiener1}}, 
asymmetric Kiener distributions K2, K3 and K4 
\code{\link{kiener2}}, \code{\link{kiener3}}, \code{\link{kiener4}}, 
conversion functions \code{\link{aw2k}}, 
estimation function \code{\link{paramkienerX}}, 
estimation function \code{\link{fitkienerX}}, 
regression function \code{\link{regkienerLX}}.
}
