% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_funcs.R
\name{farm.res}
\alias{farm.res}
\title{Adjusting a data matrix for underlying factors}
\usage{
farm.res(X, K.factors = NULL, robust = FALSE)
}
\arguments{
\item{X}{an n x p data matrix with each row being a sample.}

\item{K.factors}{a \emph{optional} number of factors to be estimated. Otherwise estimated internally. K>0.}

\item{robust}{an \emph{optional} boolean, specifying whether or not to use robust estimators for mean and variance. Default is FALSE.}
}
\value{
A list with the following items
\item{residual}{the data after being adjusted for underlying factors}
\item{loadings}{estimated factor loadings}
\item{factors}{estimated factors}
\item{nfactors}{the number of (estimated) factors}
}
\description{
Given a matrix of covariates, this function estimates the underlying factors and computes data residuals after regressing out those factors.
}
\details{
For details about the method, see Fan et al.(2017).

Using \code{robust.cov = TRUE} uses the Huber's loss to estimate the covariance matrix. For details of covariance estimation method see Fan et al.(2017).

Number of rows and columns of the data matrix must be at least 4 in order to be able to calculate latent factors.

Number of latent factors, if not provided, is estimated by the eignevalue ratio test. See Ahn and Horenstein(2013).
}
\examples{
set.seed(100)
P = 100 #dimension
N = 50 #samples
K = 3 #nfactors
Lambda = matrix(rnorm(P*K, 0,1), P,K)
F = matrix(rnorm(N*K, 0,1), N,K)
U = matrix(rnorm(P*N, 0,1), P,N)
X = Lambda\%*\%t(F)+U
X = t(X)
output = farm.res(X) #default options
output$nfactors
output = farm.res(X, K.factors = 10) #inputting factors
names(output) #list of output
}
\references{
Ahn, S. C., and A. R. Horenstein (2013): "Eigenvalue Ratio Test for the Number of Factors," Econometrica, 81 (3), 1203–1227.

Fan J., Ke Y., Wang K., "Decorrelation of Covariates for High Dimensional Sparse Regression." \url{https://arxiv.org/abs/1612.08490}
}
