% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modMAarea.R
\name{modMAarea}
\alias{modMAarea}
\title{Model-Assisted module - Generate model-assisted area estimates.}
\usage{
modMAarea(
  MApopdat,
  MAmethod,
  FIA = TRUE,
  prednames = NULL,
  modelselect = FALSE,
  landarea = "FOREST",
  pcfilter = NULL,
  rowvar = NULL,
  colvar = NULL,
  bootstrap = FALSE,
  returntitle = FALSE,
  savedata = FALSE,
  table_opts = NULL,
  title_opts = NULL,
  savedata_opts = NULL,
  gui = FALSE,
  modelselect_bydomain = FALSE,
  ...
)
}
\arguments{
\item{MApopdat}{List. Population data objects returned from modMApop().}

\item{MAmethod}{String. mase (i.e., model-assisted) method to use 
('greg', 'gregEN', 'ratio').}

\item{FIA}{Logical. If TRUE, the finite population term is removed from
estimator to match FIA estimates.}

\item{prednames}{String vector. Name(s) of predictor variables to include in
model.}

\item{modelselect}{Logical. If TRUE, an elastic net regression model is fit 
to the entire plot level data, and the variables selected in that model are 
used for the proceeding estimation.}

\item{landarea}{String. The sample area filter for estimates ('ALL',
'FOREST', 'TIMBERLAND').  If landarea=FOREST, filtered to COND_STATUS_CD =
1; If landarea=TIMBERLAND, filtered to SITECLCD in(1:6) and RESERVCD = 0.}

\item{pcfilter}{String. A filter for plot or cond attributes (including
pltassgn).  Must be R logical syntax.}

\item{rowvar}{String. Name of the row domain variable in cond or tree. If
only one domain, rowvar = domain variable. If more than one domain, include
colvar. If no domain, rowvar = NULL.}

\item{colvar}{String. Name of the column domain variable in cond or tree.}

\item{bootstrap}{Logical. If TRUE, returns bootstrap variance estimates,
otherwise uses Horvitz-Thompson estimator under simple random sampling
without replacement.}

\item{returntitle}{Logical. If TRUE, returns title(s) of the estimation
table(s).}

\item{savedata}{Logical. If TRUE, saves table(s) to outfolder.}

\item{table_opts}{List. See help(table_options()) for a list of
options.}

\item{title_opts}{List. See help(title_options()) for a list of options.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}

\item{gui}{Logical. If gui, user is prompted for parameters.}

\item{modelselect_bydomain}{Logical. If TRUE, modelselection will occur at 
the domain level as specified by rowvar and/or colvar and not at the level of
the entire sample.}

\item{...}{Parameters for modMApop() if MApopdat is NULL.}
}
\value{
If FIA=TRUE or unitvar=NULL and colvar=NULL, one data frame is
returned with tree estimates and percent sample errors. Otherwise, a list is
returned with tree estimates in one data frame (est) and percent sample
errors in another data frame (est.pse). If rawdata=TRUE, another list is
returned including raw data used in the estimation process.  If
addtitle=TRUE and returntitle=TRUE, the title for est/pse is returned. If
savedata=TRUE, all data frames are written to outfolder.

\item{est}{ Data frame. Tree estimates by rowvar, colvar (and estimation
unit). If FIA=TRUE or one estimation unit and colvar=NULL, estimates and
percent sampling error are in one data frame. } \item{pse}{ Data frame.
Percent sampling errors for estimates by rowvar and colvar (and estimation
unit). } \item{titlelst}{ List with 1 or 2 string vectors. If
returntitle=TRUE a list with table title(s). The list contains one title if
est and pse are in the same table and two titles if est and pse are in
separate tables. } \item{raw}{ List of data frames. If rawdata=TRUE, a list
including: number of plots by plot status, if in dataset (plotsampcnt);
number of conditions by condition status (condsampcnt); data used for
post-stratification (stratdat); and 1-8 tables with calculated variables
used for processing estimates and percent sampling error for table cell
values and totals (See processing data below). }

Raw data

\item{plotsampcnt}{ Table. Number of plots by plot status (ex. sampled
forest on plot, sampled nonforest, nonsampled). } \item{condsampcnt}{ DF.
Number of conditions by condition status (forest land, nonforest land,
noncensus water, census water, nonsampled). }

\item{stratdat}{ Data frame. Strata information by estimation unit. }
\tabular{lll}{ \tab \bold{Variable} \tab \bold{Description}\cr \tab ESTUNIT
\tab estimation unit\cr \tab STRATA \tab strata \cr \tab ACRES \tab area by
strata for estimation unit\cr \tab n.strata \tab number of plots in strata
(and estimation unit) \cr \tab n.total \tab number of plots for estimation
unit \cr \tab TOTACRES \tab total area for estimation unit \cr \tab strwt
\tab proportion of area (or number of plots) by strata (strata weight) \cr
\tab expfac.strata \tab expansion factor (in area unit (e.g., acres) by
strata (areavar/n.strata) \cr }

\item{processing data}{ Data frames. Separate data frames containing
calculated variables used in estimation process. The number of processing
tables depends on the input parameters. The tables include: total by
estimation unit (unit.totest); rowvar totals (unit.rowest), and if colvar is
not NULL, colvar totals, (unit.colvar); and a combination of rowvar and
colvar (unit.grpvar). If FIA=TRUE, the raw data for the summed estimation
units are also included (totest, rowest, colest, grpest, respectively).
These tables do not included estimate proportions (nhat and nhat.var).

The data frames include the following information: \tabular{lll}{ \tab
\bold{Variable} \tab \bold{Description}\cr \tab nhat \tab estimated
proportion of trees \cr \tab nhat.var \tab estimated variance of estimated
proportion of trees \cr \tab ACRES \tab total area for estimation unit \cr
\tab est \tab estimated area of trees nhat*ACRES \cr \tab est.var \tab
estimated variance of estimated area of trees nhat.var*areavar^2 \cr \tab
est.se \tab standard error of estimated area of trees sqrt(est.var) \cr \tab
est.cv \tab coefficient of variation of estimated area of trees est.se/est
\cr \tab pse \tab percent sampling error of estimate est.cv*100 \cr \tab
CI99left \tab left tail of 99 percent confidence interval for estimated area
\cr \tab CI99right \tab right tail of 99 percent confidence interval for
estimated area \cr \tab CI95left \tab left tail of 95 percent confidence
interval for estimated area \cr \tab CI95right \tab right tail of 95 percent
confidence interval for estimated area \cr \tab CI67left \tab left tail of
67 percent confidence interval for estimated area \cr \tab CI67right \tab
right tail of 67 percent confidence interval for estimated area \cr } }

Table(s) are also written to outfolder.
}
\description{
Generates area estimates by estimation unit. Estimates are calculated from
McConville et al. (2018)'s mase R package.
}
\details{
If variables are NULL, then it will prompt user to input variables.

Necessary variables:\cr \tabular{llll}{ \tab \bold{Data} \tab
\bold{Variable} \tab \bold{Description}\cr \tab tree \tab tuniqueid \tab
Unique identifier for each plot, to link to pltstrat (ex. PLT_CN).\cr \tab
\tab CONDID \tab Unique identifier of each condition on plot, to link to
cond.  Set CONDID=1, if only 1 condition per plot.\cr \tab cond \tab
cuniqueid \tab Unique identifier for each plot, to link to pltstrat (ex.
PLT_CN).\cr \tab \tab CONDID \tab Unique identifier of each condition on
plot.  Set CONDID=1, if only 1 condition per plot.\cr \tab \tab
CONDPROP_UNADJ \tab Unadjusted proportion of condition on each plot.  Set
CONDPROP_UNADJ=1, if only 1 condition per plot.\cr \tab \tab COND_STATUS_CD
\tab Status of each forested condition on plot (i.e. accessible forest,
nonforest, water, etc.)\cr \tab \tab NF_COND_STATUS_CD \tab If ACI=TRUE.
Status of each nonforest condition on plot (i.e. accessible nonforest,
nonsampled nonforest)\cr \tab \tab SITECLCD \tab If landarea=TIMBERLAND.
Measure of site productivity.\cr \tab \tab RESERVCD \tab If
landarea=TIMBERLAND. Reserved status.\cr \tab pltstrat \tab puniqueid \tab
Unique identifier for each plot, to link to cond (ex. CN).\cr \tab \tab
STATECD \tab Identifies state each plot is located in.\cr \tab \tab INVYR
\tab Identifies inventory year of each plot.\cr \tab \tab PLOT_STATUS_CD
\tab Status of each plot (i.e. sampled, nonsampled).  If not included, all
plots are assumed as sampled.\cr }

Reference names are available for the following variables: \cr ADFORCD,
AGENTCD, CCLCD, DECAYCD, DSTRBCD, KINDCD, OWNCD, OWNGRPCD, FORTYPCD,
FLDTYPCD, FORTYPCDCALC, TYPGRPCD, FORINDCD, RESERVCD, LANDCLCD, STDSZCD,
FLDSZCD, PHYSCLCD, MIST_CL_CD, PLOT_STATUS_CD, STATECD, TREECLCD, TRTCD,
SPCD, SPGRPCD
}
\note{
ADJUSTMENT FACTOR:\cr The adjustment factor is necessary to account for
nonsampled conditions. It is calculated for each estimation unit by strata.
by summing the unadjusted proportions of the subplot, microplot, and
macroplot (i.e. *PROP_UNADJ) and dividing by the number of plots in the
strata/estimation unit).

An adjustment factor is determined for each tree based on the size of the
plot it was measured on. This is identified using TPA_UNADJ as follows:

\tabular{llr}{ \tab \bold{PLOT SIZE} \tab \bold{TPA_UNADJ} \cr \tab SUBPLOT
\tab 6.018046 \cr \tab MICROPLOT \tab 74.965282 \cr \tab MACROPLOT \tab
0.999188 \cr }

If ACI=FALSE, only nonsampled forest conditions are accounted for in the
adjustment factor. \cr If ACI=TRUE, the nonsampled nonforest conditions are
removed as well and accounted for in adjustment factor.  This is if you are
interested in estimates for all lands or nonforest lands in the
All-Condition-Inventory.

stratcombine:\cr If MAmethod='PS', and stratcombine=TRUE, and less than 2
plots in any one estimation unit, all estimation units with 10 or less plots
are combined. The current method for combining is to group the estimation
unit with less than 10 plots with the estimation unit following in
consecutive order (numeric or alphabetical), restrained by survey unit
(UNITCD) if included in dataset, and continuing until the number of plots
equals 10. If there are no estimation units following in order, it is
combined with the estimation unit previous in order.

autoxreduce:\cr If MAmethod='GREG', and autoxreduce=TRUE, and there is an
error because of multicolinearity, a variable reduction method is applied to
remove correlated variables. The method used is based on the
variance-inflation factor (vif) from a linear model. The vif estimates how
much the variance of each x variable is inflated due to mulitcolinearity in
the model.

rowlut/collut:\cr There are several objectives for including rowlut/collut
look-up tables: 1) to include descriptive names that match row/column codes
in the input table; 2) to use number codes that match row/column names in
the input table for ordering rows; 3) to add rows and/or columns with 0
values for consistency. No duplicate names are allowed.

Include 2 columns in the table:\cr 1-the merging variable with same name as
the variable in the input merge table;\cr 2-the ordering or descriptive
variable.\cr If the ordering variable is the rowvar/colvar in the input
table and the descriptive variable is in rowlut/collut, set
row.orderby/col.orderby equal to rowvar/colvar. If the descriptive variable
is the rowvar/colvar in the input table, and the ordering code variable is
in rowlut/collut, set row.orderby/col.orderby equal to the variable name of
the code variable in rowlut/collut.

UNITS:\cr The following variables are converted from pounds (from FIA
database) to short tons by multiplying the variable by 0.0005.  DRYBIO_AG,
DRYBIO_BG, DRYBIO_WDLD_SPP, DRYBIO_SAPLING, DRYBIO_STUMP, DRYBIO_TOP,
DRYBIO_BOLE, DRYBIOT, DRYBIOM, DRYBIOTB, JBIOTOT, CARBON_BG, CARBON_AG

MORTALITY:\cr For Interior-West FIA, mortality estimates are mainly based on
whether a tree has died within the last 5 years of when the plot was
measured. If a plot was remeasured, mortality includes trees that were alive
the previous visit but were dead in the next visit. If a tree was standing
the previous visit, but was not standing in the next visit, no diameter was
collected (DIA = NA) but the tree is defined as mortality.

Common tree filters: \cr

\tabular{llr}{ \tab \bold{FILTER} \tab \bold{DESCRIPTION} \cr \tab "STATUSCD
== 1" \tab Live trees \cr \tab "STATUSCD == 2" \tab Dead trees \cr \tab
"TPAMORT_UNADJ > 0" \tab Mortality trees \cr \tab "STATUSCD == 2 & DIA >=
5.0" \tab Dead trees >= 5.0 inches diameter \cr \tab "STATUSCD == 2 &
AGENTCD == 30" \tab Dead trees from fire \cr }
}
\examples{
\donttest{
# Set up population dataset (see ?modMApop() for more information)
MApopdat <- modMApop(popTabs = list(tree = FIESTA::WYtree,
                                    cond = FIESTA::WYcond),
                     pltassgn = FIESTA::WYpltassgn,
                     pltassgnid = "CN",
                     unitarea = FIESTA::WYunitarea,
                     unitvar = "ESTN_UNIT",
                     unitzonal = FIESTA::WYunitzonal,
                     prednames = c("dem", "tcc", "tpi", "tnt"),
                     predfac = "tnt")

# Use GREG estimator to estimate area of forest land in our population
mod1 <- modMAarea(MApopdat = MApopdat, 
          MAmethod = "greg", 
          landarea = "FOREST")

str(mod1)
          
# Use GREG estimator to estimate area of forest land by forest type and
# stand-size class
mod2 <- modMAarea(MApopdat = MApopdat,
          MAmethod = "greg",
          landarea = "FOREST",
          rowvar = "FORTYPCD",
          colvar = "STDSZCD")
          
str(mod2)
}
}
\references{
Kelly McConville, Becky Tang, George Zhu, Shirley Cheung, and
Sida Li (2018). mase: Model-Assisted Survey Estimation. R package version
0.1.2 https://cran.r-project.org/package=mase
}
\author{
Tracey S. Frescino
}
\keyword{data}
