% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FFTrees.R
\name{FFTrees}
\alias{FFTrees}
\title{Create Fast and Frugal Trees (FFTrees)}
\usage{
FFTrees(formula = NULL, data = NULL, data.test = NULL, train.p = 1,
  rank.method = "m", verbose = F, max.levels = 4, do.cart = T,
  do.lr = T, object = NULL)
}
\arguments{
\item{formula}{A formula}

\item{data}{A model training dataset. An m x n dataframe containing n cue values for each of the m exemplars.}

\item{data.test}{(Optional) A model testing dataset (same format as data.train)}

\item{train.p}{A number between 0 and 1 indicating what percentage of the data to use for training. This only applies when data.test is not specified by the user.}

\item{rank.method}{A string indicating how to rank cues during tree construction. "m" (for marginal) means that cues will only be ranked once with the entire training dataset. "c" (conditional) means that cues will be ranked after each level in the tree with the remaining unclassified training exemplars.}

\item{verbose}{A logical value indicating whether or not to print progress reports. Can be helpful for diagnosis when the function is running slowly...}

\item{max.levels}{A number indicating the maximum number of levels considered for the tree.}

\item{do.cart, do.lr}{logical values indicating whether or not to evaluate logistic regression and/or CART on the data for comparison.}

\item{object}{An optional existing FFTrees object (do not specify by hand)}
}
\value{
A list of length 3. The first element "tree.acc" is a dataframe containing the final statistics of all trees. The second element "cue.accuracies" shows the accuracies of all cues. The third element "tree.class.ls" is a list with n.trees elements, where each element shows the final decisions for each tree for each exemplar.
}
\description{
Create Fast and Frugal Trees (FFTrees)
}

