% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThreshPts.R
\name{ThreshPts}
\alias{ThreshPts}
\title{ThreshPts}
\usage{
ThreshPts(coords, thresh, edge)
}
\arguments{
\item{coords}{Nodal coordinates}

\item{thresh}{Threshold for point removal. Ranges include: 500000-50000000}

\item{edge}{Coordinate points of the initial geometry.}
}
\value{
Coordinate points of valid nodes.
\item{CleanedNodes}{Matrix of new nodes that abide by given threshold rules.}
\item{NodeReport}{Report identifying with nodes were kept and which were removed.}
}
\description{
Clean node distribution within or outside of geometry. Optional function for complex geometries.
}
\examples{
data(polyshape)

coords = polyshape$Within
thresh = 5000000
edge = polyshape$Line

cleanpoly = ThreshPts(coords, thresh, edge)

}
