% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{n.fdr.ttest}
\alias{n.fdr.ttest}
\title{Sample size calculation for t-tests}
\usage{
n.fdr.ttest(
  fdr,
  pwr,
  delta,
  sigma = 1,
  type = "two.sample",
  pi0.hat = "BH",
  alternative = "two.sided"
)
}
\arguments{
\item{fdr}{desired FDR (scalar numeric)}

\item{pwr}{desired average power (scalar numeric)}

\item{delta}{difference of population means (vector)}

\item{sigma}{standard deviation (vector or scalar)}

\item{type}{type of t-test}

\item{pi0.hat}{approximation method for null proportion}

\item{alternative}{one- or two-sided test}
}
\value{
A list with the following components:
\item{n}{a sample size estimate}
\item{computed.avepow}{average power}
\item{desired.avepow}{desired average power}
\item{desired.fdr}{desired FDR}
\item{input.pi0}{proportion of tests with a true null hypothesis}
\item{alpha}{fixed p-value threshold for multiple testing procedure}
\item{n.its}{number of iteration}
\item{max.its}{maximum number of iteration, default is 50}
\item{n0}{lower limit for initial sample size range}
\item{n1}{upper limit for initial sample size range}
}
\description{
Find the sample size needed to have a desired false discovery rate and average power for a large number of t-tests.
}
\examples{
d = rep(c(2,0),c(100,900));
n.fdr.ttest(fdr = 0.1, pwr = 0.8, delta = d)
}
