% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BVAR.R
\name{BVAR}
\alias{BVAR}
\title{Bayesian Estimation of VAR}
\usage{
BVAR(
  data,
  plag = 2,
  iter = 10000,
  burnin = 5000,
  prior = list(b0 = 0, vb0 = 0, nu0 = 0, s0 = 0, mn = list(kappa0 = NULL, kappa1 =
    NULL)),
  ncores = 1
)
}
\arguments{
\item{data}{a \code{ts} object which include all endogenous variables in VAR}

\item{plag}{a lag order in VAR}

\item{iter}{iterations of the MCMC}

\item{burnin}{the first random draws discarded in MCMC}

\item{prior}{a list whose elements is named. \code{b0} is the prior of mean of \eqn{\beta},
and \code{vb0} is the prior of the variance of \eqn{\beta}. \code{nu0} is the degree of freedom
of Wishart distribution for \eqn{\Sigma^{-1}}, i.e., a shape parameter, and \code{s0^{-1}} is
scale parameters for the Wishart distribution. \code{mn} sets the Minnesota prior. If
\code{prior$mn$kappa0} is not \code{NULL}, \code{b0,vb0} is neglected.}

\item{ncores}{the number of CPU cores in parallel computations.}
}
\value{
a list:
\itemize{
\item \code{A}, the samples drawn for the coefficients of VAR
\item \code{sigma}, the samples drawn for the variance-covariance of the coefficients of VAR
\item \code{sumrlt}, a list include \code{varcoef, varse, q25, q975} which are
means, standard errors, 0.25 quantiles and 0.975 quantiles of \code{A}.
}
}
\description{
Estimate a VAR base on Bayesian method
}
