% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/famos_performance_function.R
\name{famos.performance}
\alias{famos.performance}
\title{Plot FAMoS Performance}
\usage{
famos.performance(input, path = getwd(), save.output = NULL, ...)
}
\arguments{
\item{input}{Either a string giving the three-digit number of the corresponding FAMoS run, e.g "004", or a matrix containing the tested models along with the respective information criteria.}

\item{path}{If \code{input} is the string of an FAMoS run, the directory containing the "FAMoS-Results" folder needs to be supplied as well. Default to \code{\link{getwd}}.}

\item{save.output}{A string containing the location and name under which the figure should be saved (format is .pdf). Default to NULL.}

\item{...}{Other graphical parameters.}
}
\value{
A plot showing the value of the selection criterion and best model of each FAMoS iteration.
}
\description{
For each FAMoS run \code{famos.performance} plots the corresponding best model and selection criterion value.
}
\details{
The upper plot shows the improvement of the selection criterion over each FAMoS iteration. The best value is shown on the right axis. The lower plot depicts the corresponding best model of each iteration. Here, green colour shows added, red colour removed and blue colour swapped parameters. The parameters of the final model are printed bold.
}
\examples{
#plot the performance of an FAMoS run
famos.performance(input = famos.run)
}
