% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_logit.R
\name{predict_logit}
\alias{predict_logit}
\title{Segmentacao a partir de modelo logit (Segmentation from the logit model)}
\usage{
predict_logit(im,modelo,fillHull=TRUE,
TargetPixels="all",
plot=TRUE)
}
\arguments{
\item{im}{Este objeto deve conter uma imagem no formato do EBImage (This
object must contain an image in EBImage format).}

\item{modelo}{modelo exportado pela funcao 'segmentation_logit' (model
exported by the 'segmentation_logit' function ).}

\item{fillHull}{:Este argumento deve receber a palavra TRUE quando se
pretende desconsiderar valores vazios dentro do foreground, caso contrario
FALSE.}

\item{TargetPixels}{:Quando se pretende segmentar todos os pixeis da imagem
deve considerar a palavra "all" (Default). Se a segmentacao deva ser feita
apenas para um conjunto de pixels, estes devem ser apresentados em uma
matriz contendo o valor 1 para os pixels de interesse e 0 para os demais.}

\item{plot}{:Indica se sera apresentada (TRUE) ou nao (FALSE) (default) a
imagem segmentada.}
}
\value{
Apresenta a imagem contida no objeto im.
}
\description{
Esta funcao permite a predicao para a segmentacao considerando o
modelo ajustado pela funcao 'segmentation_logit' (This function allows the
prediction for segmentation considering the model adjusted by the
'segmentation_logit' function).
}
\examples{

#Abrir imagem das folhas
im=read_image(example_image(3),plot=TRUE)
#Abrir paleta de cores do fundo
fundo=read_image(example_image(4),plot=TRUE)
#Abrir paleta de cores das folhas
folhas=read_image(example_image(5),plot=TRUE)
#Abrir paleta de cores referencia
ref=read_image(example_image(6),plot=TRUE)

#Gerando modelo logit
#################################################################
Modelo=segmentation_logit(im,foreground=folhas,
                         background=list(fundo,ref),
                         return="model",plot=FALSE)
summary(Modelo)

#################################################################
# Predicao a partir do modelo ajustado

im2=predict_logit(im,Modelo,plot=TRUE)
}
\seealso{
\code{\link{segmentation_logit}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
