% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eviews_pagesave.R
\name{eviews_pagesave}
\alias{eviews_pagesave}
\title{Save an `EViews` workfile page from R}
\usage{
eviews_pagesave(wf="",page="",options="",source_description="",
table_description="",keep_list="",drop_list="",keepmap_list="",dropmap_list="",
smpl_spec="")
}
\arguments{
\item{wf}{Object or a character string representing the name of an `EViews` workfile.}

\item{page}{Object or a character string representing the name of an `EViews` workfile page.}

\item{options}{Object or a character string of any of the acceptable `EViews` \code{pagesave} options, such as \code{noid}, \code{nomapval}, \code{nonames}.}

\item{source_description}{The path and name of the file to be saved.}

\item{table_description}{Further description of the \code{source_description} such as specifying the \code{range=arg}, \code{byrow}.}

\item{keep_list}{Optional. Specify the list of `EViews` object to be saved.}

\item{drop_list}{Optional. Specify the list of `EViews` object to be dropped.}

\item{keepmap_list}{Optional. Specify the list of patterns of `EViews` object to be saved.}

\item{dropmap_list}{Optional. Specify the list of patterns of `EViews` object to be dropped.}

\item{smpl_spec}{Optional. Specify the `EViews` sample string}
}
\value{
An EViews workfile.
}
\description{
Use this function to save an `EViews` workfile page from R
}
\examples{
library(EviewsR)
\dontrun{
demo(exec_commands)

eviews_pagesave(wf="EviewsR_exec_commands",source_description = "EviewsR_eviews_pagesave.csv",
drop_list = "y")
}
}
\seealso{
Other important functions: 
\code{\link{EviewsR}},
\code{\link{create_object}()},
\code{\link{eng_eviews}()},
\code{\link{eviews_graph}()},
\code{\link{eviews_import}()},
\code{\link{eviews_wfcreate}()},
\code{\link{eviews_wfsave}()},
\code{\link{exec_commands}()},
\code{\link{export}()},
\code{\link{import_table}()},
\code{\link{import}()},
\code{\link{rwalk}()},
\code{\link{set_eviews_path}()}
}
\concept{important functions}
\keyword{documentation}
