% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-Epoch.r
\name{coltimes}
\alias{coltimes}
\alias{coltimes,Epoch-method}
\title{Obtain the time points for the Epoch matrix}
\usage{
coltimes(x)

\S4method{coltimes}{Epoch}(x)
}
\arguments{
\item{x}{An Epoch object}
}
\value{
A numeric vector of time points, or column indices if time points are not defined
}
\description{
Obtain the time points for the Epoch matrix
}
\examples{
# Create an Epoch object
epoch_data <- matrix(rnorm(1000), nrow = 10)
rownames(epoch_data) <- paste0("Electrode_", 1:10)
epoch <- Epoch(epoch_data, startTime = 0, samplingRate = 100)

# get the time points of an Epoch object
coltimes(epoch)

}
\seealso{
Other Epoch methods: 
\code{\link{crop}()},
\code{\link{plot,Epoch,missing-method}},
\code{\link{resample}()},
\code{\link{show,Epoch-method}}
}
\concept{Epoch methods}
