% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{setup_future}
\alias{setup_future}
\title{Set up Future Backend}
\usage{
setup_future(
  reported_cases,
  strategies = c("multiprocess", "multiprocess"),
  min_cores_per_worker = 4
)
}
\arguments{
\item{reported_cases}{A data frame of confirmed cases (confirm) by date (date), and region (\code{region}).}

\item{strategies}{A vector length 1 to 2 of strategies to pass to \code{future::plan}. Nesting
of parallisation is from the top level down. The default is to set up nesting parallisation
with both using \code{future::multiprocess}. For single level parallisation use a single strategy
or \code{future::plan} directly. See \code{?future::plan} for options.}

\item{min_cores_per_worker}{Numeric, the minimum number of cores per worker.
Defaults to 4 which assumes 4 MCMC chains are in use per region.}
}
\value{
Numeric number of cores to use per worker. If greater than 1 pass to
\code{stan_args = list(cores = "output from setup future")} or use \code{future = TRUE}. If only a single strategy is
used then nothing is returned.
}
\description{
A utility function that aims to streamline the set up
of the required future backend with sensible defaults for most users of \code{regional_epinow}.
More advanced users are recommended to setup their own \code{future} backend based on their
available resources.
}
