% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_epinow.R
\name{run_region}
\alias{run_region}
\title{Run epinow with Regional Processing Code}
\usage{
run_region(
  target_region,
  reported_cases,
  target_folder,
  target_date,
  return_output,
  output,
  complete_logger,
  progress_fn,
  ...
)
}
\arguments{
\item{target_region}{Character string indicating the region being evaluated}

\item{reported_cases}{A data frame of confirmed cases (confirm) by date (date), and region (\code{region}).}

\item{target_folder}{Character string specifying where to save results (will create if not present).}

\item{target_date}{Date, defaults to maximum found in the data if not specified.}

\item{return_output}{Logical, defaults to FALSE. Should output be returned, this automatically updates to TRUE
if no directory for saving is specified.}

\item{output}{A character vector of optional output to return. Supported options are the individual regional estimates
("regions"),  samples ("samples"), plots ("plots"), copying the individual region dated folder into
a latest folder (if \code{target_folder} is not null - set using "latest"), the stan fit of the underlying model ("fit"), and an
overall summary across regions ("summary"). The default is to return samples and plots alongside summarised estimates and
summary statistics. If \code{target_folder} is not NULL then the default is also to copy all results into a latest folder.}

\item{complete_logger}{Character string indicating the logger to output
the completion of estimation to.}

\item{progress_fn}{Function as returned by \code{progressr::progressor}. Allows the use of a
progress bar.}

\item{...}{Pass additional arguments to \code{epinow}. See the documentation for \code{epinow} for details.}
}
\value{
A list of processed output as produced by \code{process_region}
}
\description{
Run epinow with Regional Processing Code
}
