% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.icm}
\alias{plot.icm}
\title{Plot Data from a Stochastic Individual Contact Epidemic Model}
\usage{
\method{plot}{icm}(x, y, popfrac, sim.lines, sims, sim.col, sim.lwd, sim.alpha,
  mean.line = TRUE, mean.extinct = TRUE, mean.col, mean.lwd, mean.lty, qnts,
  qnts.col, qnts.alpha, leg, leg.cex, xlim, ylim, main, axs, add = FALSE, ...)
}
\arguments{
\item{x}{an \code{EpiModel} object of class \code{icm}.}

\item{y}{output compartments or flows from \code{icm} object to plot.}

\item{popfrac}{if \code{TRUE}, plot prevalence of values rather than numbers
(see details).}

\item{sim.lines}{if \code{TRUE}, plot individual simulation lines. Default is
to plot lines for one-group models but not for two-group models.}

\item{sims}{a vector representing which individual simulation lines to plot,
with default to plot all simulations.}

\item{sim.col}{a vector of any standard R color format for simulation lines.}

\item{sim.lwd}{line width for simulation lines.}

\item{sim.alpha}{transparency level for simulation lines, where 0 = transparent
and 1 = opaque (see \code{\link{transco}}).}

\item{mean.line}{if \code{TRUE}, plot mean of simulations across time.}

\item{mean.extinct}{if \code{TRUE}, include extinct simulations in mean
calculation (see details).}

\item{mean.col}{a vector of any standard R color format for mean lines.}

\item{mean.lwd}{line width for mean lines.}

\item{mean.lty}{line type for mean lines.}

\item{qnts}{if numeric, plot polygon of simulation quantiles based on the
range implied by the argument (see details). If \code{FALSE}, supress
polygon from plot.}

\item{qnts.col}{a vector of any standard R color format for polygons.}

\item{qnts.alpha}{transparency level for quantile polygons, where 0 =
transparent and 1 = opaque (see \code{\link{transco}}).}

\item{leg}{if \code{TRUE}, plot default legend.}

\item{leg.cex}{legend scale size, with default of 0.8.}

\item{xlim}{x-axis scale limits for plot, with default based on model time steps.}

\item{ylim}{y-axis scale limits for plot, with default based on range of data.}

\item{main}{character string for main plot title.}

\item{axs}{plot axis type (see \code{\link{par}} for details), with default
to \code{"r"}.}

\item{add}{if \code{TRUE}, new plot window is not called and lines are added to
existing plot window.}

\item{...}{additional arguments to pass to main plot (see
       \code{\link{plot.default}}).}
}
\description{
Plots epidemiological data from a stochastic individual contact
             model simulated with \code{icm}.
}
\details{
This plotting function will extract the epidemiological output from a model
object of class \code{icm} and plot the time series data of disease prevalence
and other results. The summary statistics that the function calculates and
plots are individual simulation lines, means of the individual simulation
lines, and quantiles of those individual simulation lines. The mean line,
toggled on with \code{mean.line=TRUE} is calculated as the row mean
across simulations at each time step. The \code{mean.extinct} will, if set to
\code{FALSE}, exclude from this calculation any simulations with no incident
cases of disease.

Compartment prevalences are the size of a compartment over some denominator.
To plot the raw numbers from any compartment, use \code{popfrac=FALSE}; this
is the default for any plots of flows. The \code{popfrac} parameter calculates
and plots the denominators of all specified compartments using these rules: 1)
for one-group models, the prevalence of any compartment is the compartment size
divided by the total population size; 2) for two-group models, the prevalence
of any compartment is the compartment size divided by the group population size.

The quantiles show the range of outcome values within a certain specified
quantile range. By default, the interquartile range is shown: that is the
middle 50\% of the data. This is specified by \code{qnts=0.5}. To show the
middle 95\% of the data, specify \code{qnts=0.95}. To toggle off the polygons
where they are plotted by default, specify \code{qnts=FALSE}.
}
\examples{
\dontrun{
## Example 1: Plotting multiple compartment values from SIR model
param <- param.icm(trans.rate = 0.5, act.rate = 0.5, rec.rate = 0.02)
init <- init.icm(s.num = 500, i.num = 1, r.num = 0)
control <- control.icm(type = "SIR", nsteps = 100,
                       nsims = 3, verbose = FALSE)
mod <- icm(param, init, control)
plot(mod)

## Example 2: Plot only infecteds with specific output from SI model
param <- param.icm(trans.rate = 0.25, act.rate = 0.25)
init <- init.icm(s.num = 500, i.num = 10)
control <- control.icm(type = "SI", nsteps = 100,
                       nsims = 3, verbose = FALSE)
mod2 <- icm(param, init, control)
plot(mod2, y = "i.num", mean.line = FALSE)
plot(mod2, y = "si.flow", sim.lines = FALSE)
}
}
\seealso{
\code{\link{icm}}
}
\keyword{plot}

