% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.conc_microsim}
\alias{plot.conc_microsim}
\title{Plot Values from a Concurrency Microsimulation Model}
\usage{
\method{plot}{conc_microsim}(x, xlim, ylim, alpha = 1, lwd = 1, ...)
}
\arguments{
\item{x}{an object of class \code{conc_microsim}.}

\item{xlim}{x-axis scale limits for plot, with default based on model time steps.}

\item{ylim}{y-axis scale limits for plot, with default based on range of
simulated data.}

\item{alpha}{transparency level for simulation lines, where 0 = transparent
and 1 = opaque (see \code{\link{transco}}).}

\item{lwd}{line width for simulation lines.}

\item{...}{additional arguments to pass to main plot window (see
       \code{\link{plot.default}}).}
}
\description{
Plots values from an concurrency microsimulation
             epidemic model simulated with \code{conc_microsim}.
}
\details{
This function plots the disease prevalence from an \code{conc_microsim}
model. The function is currently limited to individual simulation lines of
disease prevalence. Future releases will standardize the plotting options to
those available with stochastic epidemic models, similar to those in
\code{\link{plot.icm}}.
}
\keyword{internal}

