% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utils_mumhproposaldist.R
\name{utils_mumhproposaldist}
\alias{utils_mumhproposaldist}
\title{Proposal Distribution for MH Step for \code{mu}}
\usage{
utils_mumhproposaldist(mumh, mumh.alpha, mumh.beta, mumh.alphastar,
  mumh.betastar)
}
\arguments{
\item{mumh}{The proposed or old value of \code{mu}.}

\item{mumh.alpha}{The old first shape parameter.}

\item{mumh.beta}{The old second shape parameter.}

\item{mumh.alphastar}{The new first shape parameter.}

\item{mumh.betastar}{The new second shape parameter.}
}
\value{
A realization from the (beta) proposal distribution.
}
\description{
This function caculates realizations from the proposal distribution for \code{mu} in
    the Metropolis-Hastings (MH) step in the hybrid Gibbs sampler used in the
    \code{\link{EpiBayes_ns}} and \code{\link{EpiBayes_s}} functions. Recall,
    in the context of disease freedom, \code{mu} was the average disease prevalence
    in a given diseased cluster of subjects.
}
\references{
Norets, A. and Tang, X. \emph{MCMC estimation of a finite beta mixture}. Technical
    report, Princeton University, 2010.
}
\seealso{
Used in the functions \code{\link{EpiBayes_ns}} and \code{\link{EpiBayes_s}}.
}

