% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steepness.R
\name{steepness}
\alias{steepness}
\alias{steepint}
\title{hierarchy steepness based on David's scores}
\usage{
steepness(mat, nrand = 0, Dij = TRUE, returnfig = FALSE)
}
\arguments{
\item{mat}{square dominance matrix}

\item{nrand}{numeric, the number of runs for the randomization test}

\item{Dij}{logical, by default \code{TRUE} i.e. corrected for number of interactions in a dyad, otherwise simple proportion of wins/losses}

\item{returnfig}{logical, should a figure be produced that shows the distribution of expected steepness}
}
\value{
a named vector, with the observed steepness, the expected steepness, p-value and the number of randomizations used
}
\description{
hierarchy steepness based on David's scores
}
\examples{
data(bonobos)
steepness(bonobos) # no randomization test

# with randomization test
steepness(bonobos, nrand = 100)

}
\references{
\insertRef{devries2006}{EloRating}
}
\author{
Christof Neumann
}
