% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISI.R
\name{ISI}
\alias{ISI}
\title{de Vries' I&SI ranking}
\usage{
ISI(mat, runs = 5000, printmessages = TRUE)
}
\arguments{
\item{mat}{square interaction matrix with winner in rows and losers in columns, for example the output from \code{\link{creatematrix}}}

\item{runs}{numeric, number of iterations, by default \code{5000}}

\item{printmessages}{logical, should the number of I and SI be printed (as well as a message if there is more than one solution). By default \code{TRUE}.}
}
\value{
a list with the best possible matrix (or matrices if there is more than one best solution)
}
\description{
de Vries' I&SI ranking
}
\details{
The number of interations is set substantially higher than what was suggested in the de Vries' 1998 paper, because my algorithm here is less efficient.

The I&SI algorithm (c.f. de Vries 1998) does not necessarily result in a unique order (see example below). If such a case occurs, all (equally good) solutions are returned as a list.

The function checks whether a \code{table} is supplied instead of a \code{matrix} and converts from table to matrix if possible (trying to keep the column and row names if supplied in the table).

If the matrix does not have column-names, unique column- and row-names are assigned.
}
\examples{
 data(devries98)
 h.index(devries98)
 ISI(devries98)

 ##
 data(adv)
 SEQ <- elo.seq(winner=adv$winner, loser=adv$loser, Date=adv$Date)
 mat <- creatematrix(SEQ)
 res <- ISI(mat)
 # note that this matrix is not sufficiently linear to justify such ordering
 h.index(mat)

}
\references{
\insertRef{devries1998}{EloRating}
}
\seealso{
\code{\link{ISIranks}}
}
\author{
Christof Neumann
}
