% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff.ini.seceig.tri.R
\name{eff.ini.seceig.tri}
\alias{eff.ini.seceig.tri}
\title{Tridiagonal matrix next to the maximal eigenpair}
\usage{
eff.ini.seceig.tri(a, b, xi = 1, digit.thresh = 6)
}
\arguments{
\item{a}{The lower diagonal vector.}

\item{b}{The upper diagonal vector.}

\item{xi}{The coefficient used in the improved initials to form
the convex combination of \eqn{\delta_1^{-1}} and \eqn{(v_0,-Q*v_0)_\mu},
it should between 0 and 1.}

\item{digit.thresh}{The precise level of output results.}
}
\value{
A list of eigenpair object are returned, with components \eqn{z}, \eqn{v} and \eqn{iter}.
\item{z}{The approximating sequence of the maximal eigenvalue.}
\item{v}{The approximating sequence of the corresponding eigenvector.}
\item{iter}{The number of iterations.}
}
\description{
Calculate the next to maximal eigenpair for the tridiagonal matrix
whose sums of each row should be 0.
}
\note{
The sums of each row of the input tridiagonal matrix should be 0.
}
\examples{
a = c(1:7)^2
b = c(1:7)^2

eff.ini.seceig.tri(a, b, xi = 0)
eff.ini.seceig.tri(a, b, xi = 1)
eff.ini.seceig.tri(a, b, xi = 2/5)
}
\seealso{
\code{\link{eff.ini.seceig.general}} for the general conservative matrix next to the maximal eigenpair.
}
