% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_ecogen_with_pop.R
\name{eco.fill_ecogen_with_ecopop}
\alias{eco.fill_ecogen_with_ecopop}
\title{Importation of ecopop to ecogen}
\usage{
eco.fill_ecogen_with_ecopop(
  from,
  to,
  pop,
  what = c("all", "XY", "P", "E", "C"),
  bind_columns = FALSE
)
}
\arguments{
\item{from}{ecopop object.}

\item{to}{ecogen object.}

\item{pop}{Column in slot S of ecogen object, with the population of each individual.}

\item{what}{Data frames to add into the the ecogen object. Can be one of c("all", "XY", "P", "E", "C")}

\item{bind_columns}{Bind columns of the generated tables 
with the preexisting in the ecogen slots?}
}
\description{
This function imports into an ecogen object the population data contained in  ecopop object.
The function assign the values of the data to each individual, according to the population of the 
individual.
}
\examples{

\dontrun{

data(eco.test)

# Example 1: add population data to ecogen object
result <- eco.fill_ecogen_with_ecopop(my_ecopop, eco, "pop")

# Example 2: Create ecogen object only with population data
out <- ecogen(S = eco[["S"]])
out <- eco.fill_ecogen_with_ecopop(my_ecopop, out, "pop")

# add the allele frequency data into the slot C with the function eco.add_popdata_into_ecogen
out <- eco.fill_ecogen_with_df(eco, "pop", c(1,2,3,4),  C = my_ecopop[["C"]])



}

}
\seealso{
eco.fill_ecogen_with_df
}
\author{
Leandro Roser \email{learoser@gmail.com}
}
