% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.mantel.R
\name{eco.mantel}
\alias{eco.mantel}
\title{Mantel test}
\usage{
eco.mantel(distm1, distm2, nsim = 99, alternative = c("auto", "two.sided",
  "less", "greater"), plotit = TRUE)
}
\arguments{
\item{distm1}{distance matrix.}

\item{distm2}{distance matrix.}

\item{nsim}{Number of Monte-Carlo simulations.}

\item{alternative}{The alternative hypothesis. If "auto" is selected (default) the
program determines the hypothesis by difference between the median of the simulations
and the observed value. Other options are: "two.sided", "greater" and "less".}

\item{plotit}{Should be printed a histogram of the simulation?}
}
\description{
This program computes the Mantel test between the distance matrices distm1
}
\examples{
\dontrun{
data(eco.test)
eco.mantel(dist(eco$P), dist(eco$XY), 99)
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

