% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN_seq.R
\name{predict.EQRN_seq}
\alias{predict.EQRN_seq}
\title{Predict method for an EQRN_seq fitted object}
\usage{
\method{predict}{EQRN_seq}(object, ...)
}
\arguments{
\item{object}{Fitted \code{"EQRN_seq"} object.}

\item{...}{
  Arguments passed on to \code{\link[=EQRN_predict_seq]{EQRN_predict_seq}}
  \describe{
    \item{\code{X}}{Matrix of covariates to predict the corresponding response's conditional quantiles.}
    \item{\code{Y}}{Response variable vector corresponding to the rows of \code{X}.}
    \item{\code{prob_lvls_predict}}{Vector of probability levels at which to predict the conditional quantiles.}
    \item{\code{intermediate_quantiles}}{Vector of intermediate conditional quantiles at level \code{fit_eqrn$interm_lvl}.}
    \item{\code{interm_lvl}}{Optional, checks that \code{interm_lvl == fit_eqrn$interm_lvl}.}
    \item{\code{crop_predictions}}{Whether to crop out the fist \code{seq_len} observations (which are \code{NA}) from the returned matrix.}
    \item{\code{seq_len}}{Data sequence length (i.e. number of past observations) used to predict each response quantile.
By default, the training \code{fit_eqrn$seq_len} is used.}
    \item{\code{device}}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
  }}
}
\value{
Matrix of size \code{nrow(X)} times \code{prob_lvls_predict}
(or \code{nrow(X)-seq_len} times \code{prob_lvls_predict} if \code{crop_predictions})
containing the conditional quantile estimates of the corresponding response observations at each probability level.
Simplifies to a vector if \code{length(prob_lvls_predict)==1}.
}
\description{
Predict method for an EQRN_seq fitted object
}
\details{
See \code{\link[=EQRN_predict_seq]{EQRN_predict_seq()}} for more details.
}
