% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{bmap}
\alias{bmap}
\alias{bmap,binClstPath-method}
\title{Generate an HTML burstwise webmap of a \link{binClstPath_instance}.}
\usage{
bmap(obj, folder = "embcDocs", apiKey = "", mapType = "SATELLITE",
  markerRadius = 15, display = FALSE)

\S4method{bmap}{binClstPath}(obj, folder = "embcDocs", apiKey = "",
  mapType = "SATELLITE", markerRadius = 15, display = FALSE)
}
\arguments{
\item{obj}{A \link{binClstPath_instance}.}

\item{folder}{A character string indicating the name of the folder in which
the .html file will be saved. If the folder does not exist it is
automatically created, (defaults to '~/embcDocs').}

\item{apiKey}{A character string specifying the API Key to be passed to the
Google Maps server. No Key is needed for using Google Maps JavaScript API
v3, but users may wish to specify a key in order to monitor web traffic if
the document is being posted online.}

\item{mapType}{A character string specifying the type of map to be used in
the background. This value is passed directly to the Google Maps server,
and currently can be set to ROADMAP, SATELLITE, HYBRID, or TERRAIN. (See
the Google Maps API documentation for more information.)}

\item{markerRadius}{A numeric value indicating the radius of the markers to
be plotted, (defaults to 5 pixels).}

\item{display}{A boolean value (defaults to FALSE) to automatically launch
the system's default browser from within R to visualize the generated .html
document.}
}
\value{
The path/name of the saved .html file.
}
\description{
\code{bmap} generates a burstwise .html file map of a
  \link{binClstPath_instance} in HTML5, using Google Maps JavaScript API v3
  (\url{https://developers.google.com/maps/documentation/javascript/}). The
  resulting file can be viewed locally in most browsers (an internet
  connection is required for displaying the map tiles) or posted online.
}
\examples{
\dontrun{
# -- apply EMbC to the example path --
mybcp <- stbc(expth,info=-1)
# -- generate a burstwise HTML of the output --
bmap(mybcp)
}
}
