% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PooledANOVA.R
\name{PooledANOVA}
\alias{PooledANOVA}
\title{Pooling nonsignificant interactions to Residuals}
\usage{
PooledANOVA(SS.table,del.ID,...)
}
\arguments{
\item{SS.table}{result from EMS.anova}

\item{del.ID}{id's to combine sum of squares. Use rownames of SS.table}

\item{...}{arguments to be passed to methods}
}
\description{
Pooling nonsignificant interactions to Residuals
}
\examples{
test <- gl(2, 21, 42, labels = c("Ctl","Trt"))
Group <- rep(gl(3, 7, 21, labels = c("I","II","III")),2)
Subject <- rep(1:7,6)
Y<-c(26.25,24.33,22.52,29.33,28.9,25.13,29.33,
27.47,25.19,23.53,24.57,26.88,27.86,28.09,
22.27,21.55,23.31,30.03,28.17,28.09,27.55,
  29.5,27.62,25.71,31.55,31.35,29.07,31.15,
  28.74,26.11,25.45,25.58,27.7,28.82,28.99,
  22.52,21.79,23.53,30.21,28.65,28.33,27.86)
tot.data<-data.frame(Y=Y,test=test,Group=Group,Subject=Subject)
anova.result<-EMS.anova(data.tot=tot.data,
                        Y.name="Y",
                        var.list=c("Group","Subject","test"),
                        FixRan.list=c("F","R","F"),
                        nested.list=c(NA,"Group",NA),
                        model.level=c(1,1,2))
anova.result                         
del.ID<-c("Group:test","Residuals")
PooledANOVA(anova.result,del.ID)
}

