% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get.l.opt.R
\name{get.l.opt}
\alias{get.l.opt}
\title{Identify optimum weight transformation value}
\usage{
get.l.opt(X, l, quality = "mRt", Vqn, rotation, plot = TRUE, ...)
}
\arguments{
\item{X}{Numeric matrix with m samples (rows) and n variables (columns).}

\item{l}{Numeric vector of weight transformation values to test.}

\item{quality}{Charcter scalar, qualtiy measure for against which to test
the influence of \code{l}. One out of \code{"mRm"}, \code{"mRn"},
\code{"mRt"}, \code{"mEm"}, \code{"mEn"} and \code{"mEt"}. Default is
\code{"mRt"}.}

\item{Vqn}{Numeric matrix specifying optional unscaled user-defined
end-member loadings.}

\item{rotation}{Character scalar, rotation type, default is "Varimax" (cf.
Dietze et al., 2012). One out of the rotations provided in GPArotation is
possible (cf. \code{\link{rotations}}).}

\item{plot}{Logical scalar, optional graphical output of the result.}

\item{\dots}{Further arguments passed to the function.}
}
\value{
Numeric scalar, weight tranformation value with optimal EMMA result.
}
\description{
This function returns for a series of input vaules that weight
transformation value, which yielded the highest measure of model quality.#'
}
\examples{
## load example data set
data(X, envir = environment())

## TO BE DONE!!!
}
\author{
Michael Dietze, Elisabeth Dietze
}
\references{
Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S,
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for
deciphering modern detrital processes from lake sediments of Lake Donggi
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180.
}
\seealso{
\code{\link{EMMA}}
}
\keyword{EMMA}

