% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_attributes.R
\name{set_attributes}
\alias{set_attributes}
\title{set_attributes}
\usage{
set_attributes(
  attributes,
  factors = NULL,
  col_classes = NULL,
  missingValues = NULL
)
}
\arguments{
\item{attributes}{a joined table of all attribute metadata}

\item{factors}{a table with factor code-definition pairs; see details}

\item{col_classes}{optional, list of R column classes ('ordered', 'numeric', 'factor', 'Date', or 'character', case sensitive)
will let the function infer missing 'domain' and 'measurementScale' values for attributes column.
Should be in same order as attributeNames in the attributes table, or be a named list with names corresponding to attributeNames
in the attributes table.}

\item{missingValues}{optional, a table with missing value code-deinition pairs; see details}
}
\value{
an eml "attributeList" object
}
\description{
set_attributes
}
\details{
The attributes data frame must use only the recognized column
headers shown here.  The attributes data frame must contain columns for required metadata.
These are:

\strong{For all data:}

\itemize{
  \item attributeName (required, free text field)

  \item attributeDefinition (required, free text field)

  \item measurementScale (required, "nominal", "ordinal", "ratio", "interval", or "dateTime",
 case sensitive) but it can be inferred from col_classes.
 
  \item domain (required, "numericDomain", "textDomain", "enumeratedDomain", or "dateTimeDomain",
 case sensitive) but it can be inferred from col_classes.
}

\strong{For numeric (ratio or interval) data:}
\itemize{
  \item unit (required). Unitless values should use "dimensionless" as the unit.
}

\strong{For character (textDomain) data:}
\itemize{
  \item definition (required)
}

\strong{For dateTime data:}
\itemize{
  \item formatString (required)
}

Other optional allowed columns in the attributes table are:
source, pattern, precision, numberType, missingValueCode, missingValueCodeExplanation,
attributeLabel, storageType, minimum, maximum

The \strong{factors} data frame, required for attributes in an enumerated domain, must use only the
 following recognized column headers:
\itemize{
  \item attributeName (required)
  \item code (required)
  \item definition (required)
}

The \strong{missingValues} data frame, optional, can be used in the case that multiple missing value codes
need to be set for the same attribute. This table must contain the following recognized column
headers.
\itemize{
  \item attributeName (required)
  \item code (required)
  \item definition (required)
}
}
