% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_LNR.R
\name{LNR}
\alias{LNR}
\title{The Log-Normal Race Model}
\usage{
LNR()
}
\value{
A model list with all the necessary functions for EMC2 to sample
}
\description{
Model file to estimate the Log-Normal Race Model (LNR) in EMC2.
}
\details{
Model files are almost exclusively used in \code{design()}.

Default values are used for all parameters that are not explicitly listed in the \code{formula}
argument of \code{design()}.They can also be accessed with \code{LNR()$p_types}.\tabular{llllll}{
   \strong{Parameter} \tab \strong{Transform} \tab \strong{Natural scale} \tab \strong{Default} \tab \strong{Mapping} \tab \strong{Interpretation} \cr
   \emph{m} \tab - \tab [-Inf, Inf] \tab 1 \tab  \tab Scale parameter \cr
   \emph{s} \tab log \tab [0, Inf] \tab log(1) \tab  \tab Shape parameter \cr
   \emph{t0} \tab log \tab [0, Inf] \tab log(0) \tab  \tab Non-decision time \cr
}


Because the LNR is a race model, it has one accumulator per response option.
EMC2 automatically constructs a factor representing the accumulators \code{lR} (i.e., the
latent response) with level names taken from the \code{R} column in the data.

In \code{design()}, \code{matchfun} can be used to automatically create a latent match
(\code{lM}) factor with levels \code{FALSE} (i.e., the stimulus does not match the accumulator)
and \code{TRUE} (i.e., the stimulus does match the accumulator). This is added internally
and can also be used in the model formula, typically for parameters related to
the rate of accumulation (see the example below).

Rouder, J. N., Province, J. M., Morey, R. D., Gomez, P., & Heathcote, A. (2015).
The lognormal race: A cognitive-process model of choice and latency with
desirable psychometric properties. \emph{Psychometrika, 80}, 491-513.
https://doi.org/10.1007/s11336-013-9396-3
}
\examples{
# When working with lM it is useful to design  an "average and difference"
# contrast matrix, which for binary responses has a simple canonical from:
ADmat <- matrix(c(-1/2,1/2),ncol=1,dimnames=list(NULL,"d"))
# We also define a match function for lM
matchfun=function(d)d$S==d$lR
# We now construct our design, with v ~ lM and the contrast for lM the ADmat.
design_LNRmE <- design(data = forstmann,model=LNR,matchfun=matchfun,
                       formula=list(m~lM + E,s~1,t0~1),
                       contrasts=list(m=list(lM=ADmat)))
# For all parameters that are not defined in the formula, default values are assumed
# (see Table above).
}
