% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPairs.R
\name{printPairs}
\alias{printPairs}
\title{Print information about pairs analysis}
\usage{
printPairs(eList, pairResults)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{pairResults}{output of \code{runGroups}.}
}
\value{
text to console
}
\description{
Prints the information from the \code{runPairs} function.
This could be used to save the output to a text file.
}
\examples{
eList <- Choptank_eList
year1 <- 1985
year2 <- 2010

\donttest{
pairOut_1 <- runPairs(eList, 
                      year1, year2,
                      windowSide = 0)
                       
printPairs(eList, pairOut_1)
}

}
