% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/populateParameterINFO.r
\name{populateParameterINFO}
\alias{populateParameterINFO}
\title{Populate Parameter Information Columns}
\usage{
populateParameterINFO(parameterCd, INFO, interactive = TRUE)
}
\arguments{
\item{parameterCd}{character USGS parameter code}

\item{INFO}{dataframe with value and code columns. Default is INFO}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
INFO dataframe
}
\description{
Populates INFO data frame with additional user-supplied information concerning the measured parameter.
}
\examples{
\dontrun{
library(dataRetrieval)
INFO <- readNWISsite('01594440')
parameterCd <- "01075"
parameterData <- readNWISpCode(parameterCd)
INFO$param.nm <- parameterData$parameter_nm
INFO$param.units <- parameterData$parameter_units
INFO$paramShortName <- parameterData$srsname
INFO$paramNumber <- parameterData$parameter_cd

INFO <- populateParameterINFO(parameterCd, INFO)
}
}

