% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EFDR_functions.R
\name{diagnostic.table}
\alias{diagnostic.table}
\title{2x2 diagnostic table}
\usage{
diagnostic.table(reject.true, reject, n)
}
\arguments{
\item{reject.true}{indices of the true alternative hypotheses}

\item{reject}{indices of the rejected null hypotheses}

\item{n}{total number of tests}
}
\value{
2x2 matrix
}
\description{
Returns the a 2x2 table resulting from diagnostic evaluation. 
The cells contain the number of true negatives, true positives, false negatives 
and false positives.
}
\examples{
set.seed(1)
wf = "la8"
J = 3
n = 64
h = 0.5
Z <- test_image(h = h, r = 14, n1 = n)$z
sig <- wav_th(Z, wf=wf, J=J, th = h)

Z <- Z + rnorm(n^2)*0.5
m1 <- test.bonferroni(Z, wf="la8",J=3, alpha = 0.05)
m2 <- test.fdr(Z, wf="la8",J=3, alpha = 0.05)

cat("Bonferroni diagnostic table: ",sep="\n")
diagnostic.table(sig,m1$reject_coeff,n = n^2)
cat("FDR diagnostic table: ",sep="\n")
diagnostic.table(sig,m2$reject_coeff,n = n^2)
}
\references{
Noel Cressie and Sandy Burden (2015). "Evaluation of diagnostics for hierarchical spatial statistical models." Contribution to K. V. Mardia Festschrift, Wiley, Chichester, forthcoming.
}
