% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Watson.statistic.R
\name{Watson}
\alias{Watson}
\alias{Watson.uniform}
\alias{Watson.normal}
\alias{Watson.gamma}
\alias{Watson.logistic}
\alias{Watson.laplace}
\alias{Watson.weibull}
\alias{Watson.extremevalue}
\alias{Watson.exp}
\title{Watson statistic}
\usage{
Watson.uniform(x, parameter = estimate.uniform(x))

Watson.normal(x, parameter = estimate.normal(x))

Watson.gamma(x, parameter = estimate.gamma(x))

Watson.logistic(x, parameter = estimate.logistic(x))

Watson.laplace(x, parameter = estimate.laplace(x))

Watson.weibull(x, parameter = estimate.weibull(x))

Watson.extremevalue(x)

Watson.exp(x, parameter = estimate.exp(x))

Watson(z)
}
\arguments{
\item{x}{A random sample.}

\item{parameter}{Parameters of the given distribution, MLE by default.}

\item{z}{A standard uniform random sample.}
}
\value{
Watson statistic of the given sample.
}
\description{
Compute the Watson goodness-of-fit statistic \eqn{U^2} for an i.i.d. sample,
x, to test for the given distribution with parameters unknown. Estimate parameters by ML
using \code{EDFtest} MLE function by default.
}
\examples{
x0=runif(n=100,min=-1,max=1)
Watson.uniform(x0)

x1=rnorm(n=100,mean=0,sd=1)
Watson.normal(x1)

x2=rgamma(n=100,shape=1,scale=1)
Watson.gamma(x2)

x3=rlogis(n=100,location=0,scale=1)
Watson.logistic(x3)

x4= rmutil::rlaplace(n=100,m=0,s=1)
Watson.laplace(x4)

x5=rweibull(n=100,shape=1,scale=1)
Watson.weibull(x5)
x5_log=log(x5)
Watson.extremevalue(x5_log)

x6=rexp(n=100,rate=1/2)
Watson.exp(x6)
}
\seealso{
\code{\link{estimate}} for estimating distribution parameters by ML;
\code{\link{CvM}} for calculating Cramér-von Mises statistic;
\code{\link{AD}} for calculating Anderson-Darling statistic;
\code{\link{Watson.pvalue}} for calculating P-value of Watson statistic.
}
