% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AD.statistic.R
\name{AD}
\alias{AD}
\alias{AD.uniform}
\alias{AD.normal}
\alias{AD.gamma}
\alias{AD.logistic}
\alias{AD.laplace}
\alias{AD.weibull}
\alias{AD.extremevalue}
\alias{AD.exp}
\title{Anderson-Darling statistic}
\usage{
AD.uniform(x, parameter = estimate.uniform(x))

AD.normal(x, parameter = estimate.normal(x))

AD.gamma(x, parameter = estimate.gamma(x))

AD.logistic(x, parameter = estimate.logistic(x))

AD.laplace(x, parameter = estimate.laplace(x))

AD.weibull(x, parameter = estimate.weibull(x))

AD.extremevalue(x)

AD.exp(x, parameter = estimate.exp(x))

AD(z)
}
\arguments{
\item{x}{A random sample.}

\item{parameter}{Parameters of the given distribution, MLE by default.}

\item{z}{A standard uniform random sample.}
}
\value{
Anderson-Darling statistic of the given sample.
}
\description{
Compute the Anderson-Darling goodness-of-fit statistic \eqn{A^2} for an i.i.d sample,
x, to test for the given distribution with parameters unknown.Estimate parameters by ML
using \code{EDFtest} MLE function by default.
}
\examples{
x0=runif(n=100,min=-1,max=1)
AD.uniform(x0)

x1=rnorm(n=100,mean=0,sd=1)
AD.normal(x1)

x2=rgamma(n=100,shape=1,scale=1)
AD.gamma(x2)

x3=rlogis(n=100,location=0,scale=1)
AD.logistic(x3)

x4= rmutil::rlaplace(n=100,m=0,s=1)
AD.laplace(x4)

x5=rweibull(n=100,shape=1,scale=1)
AD.weibull(x5)
x5_log=log(x5)
AD.extremevalue(x5_log)

x6=rexp(n=100,rate=1/2)
AD.exp(x6)
}
\seealso{
\code{\link{estimate}} for estimating distribution parameters by ML;
\code{\link{CvM}} for calculating Cramér-von Mises statistic;
\code{\link{Watson}} for calculating Watson statistic;
\code{\link{AD.pvalue}} for calculating P-value of Anderson-Darling statistic.
}
