% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAR_INMB_DIFF.R
\docType{class}
\name{VAR_INMB_DIFF}
\alias{VAR_INMB_DIFF}
\title{A Reference Class to represent the variance of the Incremental Net Monetary Benefit (INMB) when the standard deviation of costs and effectiveness in each group differ.}
\description{
The variance of the Incremental Net Monetary Benefit may also be calculated in a hypothetical situation when the standard deviation of costs and effectiveness in each group differ.
}
\section{Fields}{

\describe{
\item{\code{sdc_ref}}{: standard deviation of costs in the reference group}

\item{\code{sdc_exp}}{: standard deviation of costs in the experimental group}

\item{\code{sde_exp}}{: standard deviation of effectiveness in the experimental group}

\item{\code{sde_ref}}{: standard deviation of effectiveness in the reference group}

\item{\code{rho}}{: coefficient of correlation between the difference in costs (dc) and the difference in effectiveness (de)}

\item{\code{object_lambda}}{: object containing the ceiling cost-effectiveness ratio or maximum acceptable cost of a unit of effectiveness. See \link{create_object_lambda}}
}}
\examples{
## First, create a lambda object
object_lambda <- create_object_lambda (20000)
## Then, create a var_inmb_diff object
var_inmb_diff <- create_object_var_inmb_diff(sdc_ref=2100, sdc_exp=2100, sde_ref = 0.12,
sde_exp = 0.12, rho = 0.1,object_lambda = object_lambda)
}
\seealso{
\link{create_object_var_inmb_direct} to directly provide a value for the variance of the Incremental Net Monetary Benefit

\link{create_object_var_inmb} to calculate the theoretical standard deviation of the expected INB with the same standard deviation in the reference and the experimental group

\link{create_object_var_inmb_diff} the constructor
 \describe{
 \item{set_sdc_ref(sdc_ref):}{sets the standard deviation of costs in the reference group of this VAR_INMB_DIFF object}
 \item{set_sdc_exp(sdc_exp):}{sets the standard deviation of costs in the experimental group of this VAR_INMB_DIFF object}
 \item{set_sde_exp(sde_exp):}{sets the standard deviation of effectiveness in the experimental group of this VAR_INMB_DIFF object}
 \item{set_sde_ref(sde_ref):}{sets the standard deviation of effectiveness in the reference group of this VAR_INMB_DIFF object}
 \item{set_rho(rho):}{Sets the coefficient of correlation between the difference in costs (dc) and the difference in effectiveness (de) of this VAR_INMB_DIFF object}
 \item{set_lambda(lambda):}{sets the lambda value of this VAR_INMB_DIFF object}
 \item{get_var_inmb():}{Return the calculated variance of the Incremental Net Monetary Benefit when the standard deviation of costs and effectiveness in each group differ.}
 }
}

