% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POP.R
\docType{class}
\name{POP}
\alias{POP}
\title{A Reference Class to represent the target population}
\description{
The expected value of perfect information (EVPI) is estimated for the entire population targeted by the evaluated intervention.
}
\section{Fields}{

\describe{
\item{\code{horizon}}{: Time horizon in years considered in the estimation of the EVPI.
Finite time horizons are recommended in order to control for the complex and uncertain process of future changes.
Furthermore, because of discounting, the impact of a time horizon over 15 or 20 years on the estimation of EVPI is insignificant.}

\item{\code{discount}}{: Annual discount rate considered in the estimation of the EVPI. The annual discount rate is defined in each country, usually within 3 to 6\%.}

\item{\code{N_year}}{: Number of individuals likely to be targeted by the evaluated intervention each year}
}}
\section{Methods}{

 \describe{
 \item{set_discount(discount):}{sets the discount for this POP object}
 \item{set_N_year(N_year):}{sets the N_year of this POP object}
 \item{set_horizon(horizon):}{sets the horizon of this POP object}
 }
}
\examples{
object_pop <- create_object_pop(horizon = 20, discount=0.04, N_year = 52000)
}
\seealso{
\link{create_object_pop} the constructor
}

