% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstFreq.R
\name{EstFreq}
\alias{EstFreq}
\title{EstFreq}
\usage{
EstFreq(x, t, min.cell = 5, k = 20000)
}
\arguments{
\item{x}{a matrix containing the assumed probabilities for the expected transition tables}

\item{t}{number of time intervalls}

\item{min.cell}{a single integer defines what counts as a low frequency (5 by convention)}

\item{k}{Number of simulations (at least 20.000 is recommended)}
}
\description{
Simulates k state-transition tables (see: \code{\link{StateTrans}}) based one state-transtion table containing expected population frequencies (relative frequencies!). 
If simulations should be conducted for different numbers of time intervalls, please see: \code{\link{EstTime}}
}
\details{
The matrix must have 2*4 dimensions with the following information:
\itemize{
 \item First column represents if behavior of interest is shown
 \item Second column represents if behavior of interest is not shown
 \item First row shows if behavior of interest was shown by both partners in the previous time interval
 \item Second row shows if behavior of interest was shown only by the partner in the previous time interval 
 \item Third row shows if behavior of interest was shown only by the actor in the previous time interval
 \item Second row shows if behavior of interest was not shown in the previous time interval
}
}
\examples{
\dontrun{
my.trans.table<-matrix(c(0.57, 0.13,0.05,0.05,0.05, 0.05,0.05,0.05),4,2)

my.cellproblems<-EstFreq(my.trans.table, 100, 5, k=20000)

my.cellproblems
}

}
