% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_ml_data.R
\name{double_ml_data_from_data_frame}
\alias{double_ml_data_from_data_frame}
\title{Wrapper for Double machine learning data-backend initialization from data.frame.}
\usage{
double_ml_data_from_data_frame(
  df,
  x_cols = NULL,
  y_col = NULL,
  d_cols = NULL,
  z_cols = NULL,
  data_class = "DoubleMLData",
  use_other_treat_as_covariate = TRUE
)
}
\arguments{
\item{df}{(\code{data.frame()})\cr
Data object.}

\item{x_cols}{(\code{NULL}, \code{character()}) \cr
The covariates. If \code{NULL}, all variables (columns of \code{data}) which are neither specified as outcome variable \code{y_col}, nor as treatment variables \code{d_cols}, nor as instrumental variables \code{z_cols} are used as covariates. Default is \code{NULL}.}

\item{y_col}{(\code{character(1)}) \cr
The outcome variable.}

\item{d_cols}{(\code{character()}) \cr
The treatment variable(s).}

\item{z_cols}{(\code{NULL}, \code{character()}) \cr
The instrumental variables. Default is \code{NULL}.}

\item{data_class}{(\code{character(1)}) \cr
Class of returned object. By default, an object of class \code{DoubleMLData} is returned. Setting \code{data_class = "data.table"} returns an object of class \code{data.table}.}

\item{use_other_treat_as_covariate}{(\code{logical(1)}) \cr
Indicates whether in the multiple-treatment case the other treatment variables should be added as covariates. Default is \code{TRUE}.}
}
\value{
Creates a new instance of class \code{DoubleMLData} by default. Class of returned object may change with input provided by option \code{data_class}.
}
\description{
Initalization of DoubleMLData from \code{data.frame}.
}
\examples{
df = make_plr_CCDDHNR2018(return_type = "data.frame")
x_names = names(df)[grepl("X", names(df))]
obj_dml_data = double_ml_data_from_data_frame(df = df, x_cols = x_names, 
                                             y_col = "y", d_cols = "d")
}
