% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_by_coordinate_ref.R
\name{subset_by_coordinate_ref}
\alias{subset_by_coordinate_ref}
\title{Subset Occurrence Dataframe}
\usage{
subset_by_coordinate_ref(dataframe, coordinate_reference, distance_threshold)
}
\arguments{
\item{dataframe}{A dataframe from which occurrence data will be subset}

\item{coordinate_reference}{A pair of longitude/latitude coordinates that will mark the centre of the occurrence data}

\item{distance_threshold}{The distance from the coordinate reference that will be included in the subset}
}
\value{
A dataframe with observations that occurred within the distance threshold from the coordinate reference
}
\description{
Subsets an occurrence dataframe by using a pair of reference coordinates and a radius distance.
}
\examples{
# subset the occurrence data returning only data points 50km from the reference coordinates
Colombia_site_1 <-  subset_by_coordinate_ref(

 dataframe = Colombia,
 coordinate_reference = c(-74.083310, 7.488485),
 distance_threshold = 50000

)

head(Colombia_site_1)
}
