% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbif_to_dataframe.R
\name{gbif_to_dataframe}
\alias{gbif_to_dataframe}
\title{Convert GBIF Object}
\usage{
gbif_to_dataframe(GBIF_object)
}
\arguments{
\item{GBIF_object}{An object queried from the GBIF database: a list containing occurrence data for a specified taxon and location.}
}
\value{
An R dataframe containing the occurrence data from the GBIF object.
}
\description{
Convert a GBIF object into workable R dataframe.
}
\examples{
# convert the GBIF object containing occurrence plant data from 2020 and 2019
\donttest{
 library(rgbif)

 Cambodia_code <- isocodes[grep("Cambodia", isocodes$name), "code"]

 Plant_taxonkey <- name_backbone("Plantae")$kingdomKey

 plant_cambodia.gbif <- occ_search(
   hasCoordinate = TRUE,
   limit = 99990,
   taxonKey = Plant_taxonkey,
   year = c("2020", "2019"),
   country = Cambodia_code
 )

 plant_cambodia.df <- gbif_to_dataframe(plant_cambodia.gbif)

 head(plant_cambodia.df)
}
}
