% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_graph_time.R
\name{get_graph_time}
\alias{get_graph_time}
\title{Get the graph date-time or timezone}
\usage{
get_graph_time(graph, as_posixct = TRUE, get_tz = FALSE)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}

\item{as_posixct}{an option to return the graph time
as POSIXct.}

\item{get_tz}{an option to just return the graph's
time zone.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Set the time and timezone for a graph
object of class \code{dgr_graph}.
}
\examples{
library(magrittr)

# Create an empty graph and set the graph's time;
# if nothing is supplied for the `tz` argument,
# `GMT` is used as the time zone
graph <-
  create_graph() \%>\%
    set_graph_time(
      time = "2015-10-25 15:23:00")

# Get the graph's time as a POSIXct-formatted object
# using `get_graph_time()`
graph \%>\% get_graph_time
#> [1] "2015-10-25 15:23:00 GMT"

# Get the graph's time as a character object
graph \%>\% get_graph_time(as_posixct = FALSE)
#> [1] "2015-10-25 15:23:00"

# Get just the time zone associated with the
# graph time
graph \%>\% get_graph_time(get_tz = TRUE)
#> [1] "GMT"
}

