% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.hist.R
\name{ds.hist}
\alias{ds.hist}
\title{Histogram breaks and frequencies}
\usage{
ds.hist(x, breaks= "Sturges", tojson=FALSE)
}
\arguments{
\item{x}{The input numeric vector, matrix or data frame}

\item{breaks}{The method or the number of classes for the histogram}

\item{tojson}{If TRUE the results are returned in json format, default returns a list}
}
\value{
A list or json file with the following components:

\itemize{
\item cuts The boundaries of the histogram classes
\item density The density of each histogram class
\item normal.curve.x Abscissa of the normal curve 
\item normal.curve.y Ordinate of the normal curve 
\item fit.line.x Abscissa of the data density curve 
\item fit.line.y Ordinate of the data density curve 
\item mean The average value of the input vector
\item median The median value of the input data
}
}
\description{
This function computes the histogram parameters of the numeric input vector. The default for 
breaks is the value resulted from Sturges algorithm.
}
\details{
The possible values for breaks are Sturges see \code{\link[grDevices]{nclass.Sturges}}, 
Scott see \code{\link[grDevices]{nclass.scott}} and FD or Freedman Diaconis \code{\link[grDevices]{nclass.FD}}
which are in package \pkg{grDevices}.
}
\examples{
# with a vector as an input and the defaults parameters
vec <- as.vector(iris$Sepal.Width)
ds.hist(vec)

# OpenBudgets.eu Dataset Example:
Wuppertal_df
ds.hist(Wuppertal_df$Amount, tojson = TRUE)

}
\seealso{
\code{\link{ds.analysis}}, \code{\link{open_spending.ds}}
}
\author{
Kleanthis Koupidis
}
