% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_depths.R
\name{fncDepth}
\alias{fncDepth}
\alias{fncDepth.matrix}
\alias{fncDepth.zoo}
\title{Basic function for functional depths}
\usage{
fncDepth(u, X = NULL, method = "MBD", byrow = NULL, ...)

\method{fncDepth}{matrix}(u, X = NULL, method = "MBD", byrow = NULL,
  ...)

\method{fncDepth}{zoo}(u, X = NULL, method = "MBD", byrow = NULL,
  ...)
}
\arguments{
\item{u}{data}

\item{X}{reference set. If null u will be used as reference.}

\item{method}{depth method - "MBD" (default), or "FM" (Frainman-Muniz depth)}

\item{byrow}{logical or character.}

\item{\dots}{additional arguments passed to fncDepthFM.}
}
\description{
Calculates depth functions.
}
\examples{

x <- matrix(rnorm(60), ncol = 20)
fncDepth(x, method = "FM", dep1d = "Mahalanobis")
fncDepth(x, byrow = FALSE)

# zoo and xts
library(xts)
data(sample_matrix)
sample.xts <- as.xts(sample_matrix, descr = "my new xts object")
fncDepth(sample.xts)

}
