% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{ScaleCurve-class}
\alias{ScaleCurve-class}
\title{ScaleCurve and ScaleCurveList}
\description{
ScaleCurve is a class that stores results of \link{scaleCurve} function.
}
\details{
ScaleCurve intherits behviour from numeric vector, so raw values of ScaleCurve can be accessed via as.numeric(...).



The mechanism of creating plots with multiple curves is shown in \link{DepthCurve-class} (same mechanism is applied for AsymmetryCurve).
}
\examples{
require(mvtnorm)
x = mvrnorm(n = 100, mu = c(0,0), Sigma = 2*diag(2))
y = rmvt(n = 100, sigma = diag(2), df = 4)
s1 = scaleCurve(x, method = "Projection", plot = FALSE)
s2 = scaleCurve(y, method = "Projection", plot = FALSE, name = "Set2")


sc_list = s1 \%+\% s2 # Add one curve to another

plot(sc_list) # Draw plot with two curves

z = mvrnorm(n = 100, mu = c(0,0), Sigma = 1*diag(2))
s3 = scaleCurve(z, method = "Projection", plot = FALSE)
plot(sc_list\%+\%s3) # Add third curve and draw a plot
}

