% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{replaceColors}
\alias{replaceColors}
\title{Replaces colors in \link{DLData} object}
\usage{
replaceColors(data, colors)
}
\arguments{
\item{data}{the data}

\item{colors}{the new colors}
}
\value{
the modified \link{DLData} object
}
\description{
Replaces colors in \link{DLData} object
}
\examples{
# read data and create DLData object
seqs <- read.table(system.file("extdata", "cjun.txt", package = "DepLogo"), 
    stringsAsFactors = FALSE)
data <- DLData(sequences = seqs[, 1], weights = log1p(seqs[, 2]) )

replaceColors(data, c("red", "green", "blue", "yellow"))
}
\seealso{
\link{replaceColors}
}
\author{
Jan Grau <grau@informatik.uni-halle.de>
}
