% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{hte_plot}
\alias{hte_plot}
\title{hte_plot}
\usage{
hte_plot(
  x,
  ...,
  boot = TRUE,
  n_boot = 1000,
  cut_points = NULL,
  custom_labels = NULL,
  zero_int = TRUE
)
}
\arguments{
\item{x}{estimated model from \code{metalearner_ensemble},
\code{metalearner_deepneural}, \code{pattc_ensemble}, or \code{pattc_neural}.}

\item{...}{Additional arguments}

\item{boot}{logical for using bootstraps to estimate confidence intervals.}

\item{n_boot}{number of bootstrap iterations. Only used with boot = TRUE.}

\item{cut_points}{numeric vector for cut-off points to generate subgroups from
covariates. If left blank a vector generated from median values will be used.}

\item{custom_labels}{character vector for the names of subgroups.}

\item{zero_int}{logical for vertical line at 0 x intercept.}
}
\value{
\code{ggplot} object illustrating subgroup HTE and 95\% confidence
intervals.
}
\description{
Produces plot to illustrate sub-group Heterogeneous Treatment Effects (HTE)
of estimated CATEs from \code{metalearner_ensemble} and
\code{metalearner_deepneural}, as well as PATT-C from \code{pattc_ensemble}
and \code{pattc_neural}.
}
\examples{
\donttest{
# load dataset
set.seed(123456)
xlearner_nn <- metalearner_deepneural(cov.formula = support_war ~ age +
                                  income  + employed  + job_loss,
                                  data = exp_data,
                                  treat.var = "strong_leader",
                                  meta.learner.type = "X.Learner",
                                  stepmax = 2e+9,
                                  nfolds = 5,
                                  algorithm = "rprop+",
                                  hidden.layer = c(3),
                                  linear.output = FALSE,
                                  binary.outcome = FALSE)

hte_plot(xlearner_nn)
                                  }
                    
}
